/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.fabric.BaseLangProvider;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_5321;
import net.minecraft.class_7403;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;

public class RegistrateLangProvider
extends BaseLangProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> owner;
    private final AccessibleLanguageProvider upsideDown;
    private static final String NORMAL_CHARS = "abcdefghijklmn\u00f1opqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = "\u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";

    public RegistrateLangProvider(AbstractRegistrate<?> owner, FabricDataOutput packOutput) {
        super(packOutput, "en_us");
        this.owner = owner;
        this.upsideDown = new AccessibleLanguageProvider(packOutput, "en_ud");
    }

    @Override
    public EnvType getSide() {
        return EnvType.CLIENT;
    }

    public String method_10321() {
        return "Lang (en_us/en_ud)";
    }

    @Override
    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.owner.genData(ProviderType.LANG, this);
        super.generateTranslations(translationBuilder);
    }

    public static final String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public <T> String getAutomaticName(NonNullSupplier<? extends T> sup, class_5321<class_2378<T>> registry) {
        return RegistrateLangProvider.toEnglishName(((class_2378)class_7923.field_41167.method_29107(registry)).method_10221(sup.get()).method_12832());
    }

    public void addBlock(NonNullSupplier<? extends class_2248> block) {
        this.addBlock(block, this.getAutomaticName(block, class_7924.field_41254));
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends class_2248> block, String tooltip) {
        this.addBlock(block);
        this.addTooltip(block, tooltip);
    }

    public void addBlockWithTooltip(NonNullSupplier<? extends class_2248> block, String name, String tooltip) {
        this.addBlock(block, name);
        this.addTooltip(block, tooltip);
    }

    public void addItem(NonNullSupplier<? extends class_1792> item) {
        this.addItem(item, this.getAutomaticName(item, class_7924.field_41197));
    }

    public void addItemWithTooltip(NonNullSupplier<? extends class_1792> block, String name, List<@NonnullType String> tooltip) {
        this.addItem(block, name);
        this.addTooltip(block, tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends class_1935> item, String tooltip) {
        this.add(((class_1935)item.get()).method_8389().method_7876() + ".desc", tooltip);
    }

    public void addTooltip(NonNullSupplier<? extends class_1935> item, List<@NonnullType String> tooltip) {
        for (int i = 0; i < tooltip.size(); ++i) {
            this.add(((class_1935)item.get()).method_8389().method_7876() + ".desc." + i, tooltip.get(i));
        }
    }

    public void add(class_1761 tab, String name) {
        class_7417 contents = tab.method_7737().method_10851();
        if (!(contents instanceof class_2588)) {
            throw new IllegalArgumentException("Creative tab does not have a translatable name: " + tab.method_7737());
        }
        class_2588 lang = (class_2588)contents;
        this.add(lang.method_11022(), name);
    }

    public void addEntityType(NonNullSupplier<? extends class_1299<?>> entity) {
        this.addEntityType(entity, this.getAutomaticName(entity, class_7924.field_41266));
    }

    private String toUpsideDown(String normal) {
        char[] ud = new char[normal.length()];
        for (int i = 0; i < normal.length(); ++i) {
            char c = normal.charAt(i);
            if (c == '%') {
                Object fmtArg = "";
                while (Character.isDigit(c) || c == '%' || c == '$' || c == 's' || c == 'd') {
                    fmtArg = (String)fmtArg + c;
                    c = ++i == normal.length() ? (char)'\u0000' : normal.charAt(i);
                }
                --i;
                for (int j = 0; j < ((String)fmtArg).length(); ++j) {
                    ud[normal.length() - 1 - i + j] = ((String)fmtArg).charAt(j);
                }
                continue;
            }
            int lookup = NORMAL_CHARS.indexOf(c);
            if (lookup >= 0) {
                c = UPSIDE_DOWN_CHARS.charAt(lookup);
            }
            ud[normal.length() - 1 - i] = c;
        }
        return new String(ud);
    }

    @Override
    public void add(String key, String value) {
        super.add(key, value);
        this.upsideDown.add(key, this.toUpsideDown(value));
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        return CompletableFuture.allOf(super.method_10319(cache), this.upsideDown.method_10319(cache));
    }

    public void addBlock(Supplier<? extends class_2248> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_2248 key, String name) {
        this.add(key.method_9539(), name);
    }

    public void addItem(Supplier<? extends class_1792> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1792 key, String name) {
        this.add(key.method_7876(), name);
    }

    public void addItemStack(Supplier<class_1799> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1799 key, String name) {
        this.add(key.method_7922(), name);
    }

    public void addEnchantment(Supplier<? extends class_1887> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1887 key, String name) {
        this.add(key.method_8184(), name);
    }

    public void addEffect(Supplier<? extends class_1291> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1291 key, String name) {
        this.add(key.method_5567(), name);
    }

    public void addEntityType(Supplier<? extends class_1299<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(class_1299<?> key, String name) {
        this.add(key.method_5882(), name);
    }

    static {
        if (NORMAL_CHARS.length() != UPSIDE_DOWN_CHARS.length()) {
            throw new AssertionError((Object)"Char maps do not match in length!");
        }
    }

    private static class AccessibleLanguageProvider
    extends BaseLangProvider {
        public AccessibleLanguageProvider(FabricDataOutput output, String locale) {
            super(output, locale);
        }
    }
}

